#ifndef __IWindowChangeListener__
#define __IWindowChangeListener__

#include <MathTools/CPoint.hpp>
#include <MathTools/CDimension.hpp>

//	===========================================================================

using Exponent::MathTools::CPoint;
using Exponent::MathTools::CDimension;

/**
 * @cond
 */
#ifndef __IWINDOW_GUARD__
#define __IWINDOW_GUARD__
	namespace Exponent { namespace GUI { namespace Windowing { interface IWindow; } } }
	using Exponent::GUI::Windowing::IWindow;
#endif
/**
 * @endcond
 */

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Listeners
		{
			/**
			 * @interface IWindowChangeListener IWindowChangeListener.hpp
			 * @brief Allows windows to respond to change events such as sizing, moving etc..
			 *
			 * @date 18/03/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: IWindowChangeListener.hpp,v 1.5 2007/02/11 02:16:22 paul Exp $
			 */
			interface IWindowChangeListener
			{

//	===========================================================================

			public:

//	===========================================================================

				/**
				 * Construction
				 */
				IWindowChangeListener() { }

				/**
				 * Destruction
				 */
				virtual ~IWindowChangeListener() { }

//	===========================================================================

				/**
				 * Window has been resized
				 * @param window The window that has been resized
				 * @param newDimension The new dimension of the window
				 */
				virtual void windowSized(IWindow *window, const CDimension &newDimension) = 0;

				/**
				 * Window has been moved
				 * @param window The window that has been resized
				 * @param newTopLeft The new top left position of the window
				 */
				virtual void windowMoved(IWindow *window, const CPoint &newTopLeft) = 0;

				/**
				 * Window has been closed
				 * @param window The window that has been resized
				 * @retval bool True if you want to allow the window to close, false otherwise
				 */
				virtual bool windowClosed(IWindow *window) = 0;

				/**
				 * Window has been opened
				 * @param window The window that has been resized
				 */
				virtual void windowOpened(IWindow *window) = 0;

				/**
				 * Window has been minimised
				 * @param window The window that has been resized
				 */
				virtual void windowMinimised(IWindow *window) = 0;

				/**
				 * Window has been maximised
				 * @param window The window that has been resized
				 */
				virtual void windowMaximised(IWindow *window) = 0;

//	===========================================================================
			};
		}
	}
}
#endif	// End of IWindowChangeListener.hpp